import numpy as np

def calc_mu(A, beta):
    z = np.dot(np.array(A), np.array(beta))
    neg_indices = np.array(z <= 0)
    pos_indices = np.array(z >= 0)
    # print(pos_indices)
    # print( "sum pos = {}".format( np.sum(z[pos_indices])))
    mu = -1.0*np.sum(z[neg_indices])/np.sum(z[pos_indices])
    return mu


# return matrix for projection onto I-P where P is matrix of orthogonal projection onto range(A)
def calc_complement_proj_matrix(A):
    n,d = np.shape(A)
    A = np.matrix(A)
    PP = calc_proj_matrix(A) # projection matrix
    # PP = np.random.normal(0,1,n)
    # PP = PP/np.linalg.norm(PP)
    # P = np.outer(PP,PP)
    # # return(P)

    return np.array(np.matrix(np.identity(n)) - PP)


# return matrix for orthogonal projection onto range(A)
def calc_proj_matrix(A):
    Q, R = np.linalg.qr(A)
    Q= np.matrix(Q)
    return Q * Q.T
    # return A*np.linalg.inv(A.T*A)*A.T